/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.mybatis.mapper;

import net.sinodawn.framework.database.context.EntityContext;
import net.sinodawn.framework.database.context.instance.EntityContextInstance;
import net.sinodawn.framework.database.sql.Order;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface DaoMapper {
    void insert(@Param("contextInstance") EntityContextInstance contextInstance);

    void batchInsert(@Param("context") EntityContext context, @Param("contextInstanceList") List<EntityContextInstance> contextInstanceList);

    void deleteById(@Param("contextInstance") EntityContextInstance contextInstance);

    void batchDeleteById(@Param("context") EntityContext context, @Param("contextInstanceList") List<EntityContextInstance> contextInstanceList);

    List<Map<String, Object>> selectByIds(@Param("context") EntityContext context, @Param("idList") List<Object> idList, @Param("selectColumnList") List<String> selectColumnList, @Param("orderList") List<Order> orderList);

    List<Map<String, Object>> select(@Param("contextInstance") EntityContextInstance contextInstance, @Param("selectColumnList") List<String> selectColumnList, @Param("orderList") List<Order> orderList);

    Map<String, Object> selectFirst(@Param("contextInstance") EntityContextInstance contextInstance, @Param("selectColumnList") List<String> selectColumnList, @Param("orderList") List<Order> orderList);

    List<Map<String, Object>> batchSelect(@Param("context") EntityContext context, @Param("contextInstanceList") List<EntityContextInstance> contextInstanceList, @Param("selectColumnList") List<String> selectColumnList, @Param("orderList") List<Order> orderList);

    List<Map<String, Object>> selectUnion(@Param("contextInstance") EntityContextInstance contextInstance, @Param("selectColumnList") List<String> selectColumnList, @Param("orderList") List<Order> orderList);

    void updateById(@Param("contextInstance") EntityContextInstance contextInstance);

    void updateByIds(@Param("contextInstance") EntityContextInstance contextInstance, @Param("idList") List<Object> idList);

    void batchUpdateByIds(@Param("context") EntityContext context, @Param("contextInstanceList") List<EntityContextInstance> contextInstanceList, @Param("updateColumnList") List<String> updateColumnList);

    int count(@Param("contextInstance") EntityContextInstance contextInstance);

    int batchCount(@Param("context") EntityContext context, @Param("contextInstanceList") List<EntityContextInstance> contextInstanceList);

    List<Map<String, Object>> lockByIds(@Param("context") EntityContext context, @Param("idList") List<Object> idList);
}
