/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.log;

import net.sinodawn.module.sys.log.bean.CoreLogBean;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public enum LogQueue {
   INSTANCE;

   private Queue<CoreLogBean> queue = new ConcurrentLinkedQueue();

   public CoreLogBean poll() {
      return (CoreLogBean)this.queue.poll();
   }

   public void offer(CoreLogBean log) {
      this.queue.offer(log);
   }

   public boolean isEmpty() {
      return this.queue.isEmpty();
   }
}
