/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.log;

import net.sinodawn.module.sys.log.bean.CoreLogBean;
import net.sinodawn.module.sys.log.service.CoreLogService;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class LogConsumer {
   private static final int MAX_INSERT_SIZE = 50;
   @Autowired
   private CoreLogService logService;

   @Scheduled(
      fixedDelay = 1000L
   )
   public void consume() {
      LogQueue queue = LogQueue.INSTANCE;
      ArrayList insertLogList = new ArrayList();

      while(!queue.isEmpty()) {
         CoreLogBean log = queue.poll();
         insertLogList.add(log);
         if (insertLogList.size() >= 50) {
            this.logService.insertLog(insertLogList);
            insertLogList.clear();
         }
      }

      if (!insertLogList.isEmpty()) {
         this.logService.insertLog(insertLogList);
         insertLogList.clear();
      }

   }
}
