/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import net.sinodawn.framework.data.CaseInsensitiveLinkedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.IOException;

public class JacksonCaseInsensitiveLinkedMapSerializer extends JsonSerializer<CaseInsensitiveLinkedMap<String>> {
    private static Logger logger = LogManager.getLogger(JacksonCaseInsensitiveLinkedMapSerializer.class);

    public JacksonCaseInsensitiveLinkedMapSerializer() {
    }

    public void serialize(CaseInsensitiveLinkedMap<String> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        value.forEach((k, v) -> {
            try {
                gen.writeStringField(k, v);
            } catch (IOException var4) {
                logger.error(var4.getMessage(), var4);
            }

        });
        gen.writeEndObject();
    }
}
