/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.json.deserializer;


import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import net.sinodawn.framework.utils.ConvertUtils;

import java.lang.reflect.Type;

public enum DefaultJsonDeserializer implements ObjectDeserializer {
    INSTANCE;

    private DefaultJsonDeserializer() {
    }

    public <T> T deserialze(DefaultJSONParser paramDefaultJSONParser, Type paramType, Object paramObject) {
        return (T) ConvertUtils.convert(paramDefaultJSONParser.parse(paramObject), (Class)paramType);
    }

    public int getFastMatchToken() {
        return 2;
    }
}
