/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.text.impl;

import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.io.text.FileToTextExtractor;
import net.sinodawn.framework.utils.EncodingUtils;
import net.sinodawn.framework.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TxtStyleFileToTextExtractor implements FileToTextExtractor {
   public static final TxtStyleFileToTextExtractor instance = new TxtStyleFileToTextExtractor();

   public boolean match(String fileExtension) {
      return "txt".equalsIgnoreCase(fileExtension) || "xml".equalsIgnoreCase(fileExtension);
   }

   public String extract(File file) {
      StringBuilder sb = new StringBuilder();

      try {
         FileInputStream fis = new FileInputStream(file);
         Throwable var4 = null;

         try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            Throwable var6 = null;

            try {
               String charset = EncodingUtils.detect(file);
               byte[] byteArray = new byte[4096];
               boolean var9 = false;

               int length;
               while((length = bis.read(byteArray)) != -1) {
                  sb.append(new String(byteArray, 0, length, charset));
               }

               String var10 = sb.toString();
               return var10;
            } catch (Throwable var35) {
               var6 = var35;
               throw var35;
            } finally {
               if (bis != null) {
                  if (var6 != null) {
                     try {
                        bis.close();
                     } catch (Throwable var34) {
                        var6.addSuppressed(var34);
                     }
                  } else {
                     bis.close();
                  }
               }

            }
         } catch (Throwable var37) {
            var4 = var37;
            throw var37;
         } finally {
            if (fis != null) {
               if (var4 != null) {
                  try {
                     fis.close();
                  } catch (Throwable var33) {
                     var4.addSuppressed(var33);
                  }
               } else {
                  fis.close();
               }
            }

         }
      } catch (IOException var39) {
         throw new FileException(var39);
      }
   }

   public String extract(InputStream is) {
      File temp = null;

      String var3;
      try {
         temp = FileUtils.createTempFile();
         var3 = this.extract(temp);
      } finally {
         FileUtils.deleteQuietly(temp);
      }

      return var3;
   }
}
