/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.text.impl;

import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.io.text.FileToTextExtractor;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class PdfFileToTextExtractor implements FileToTextExtractor {
   public static final PdfFileToTextExtractor instance = new PdfFileToTextExtractor();

   public boolean match(String fileExtension) {
      return "pdf".equalsIgnoreCase(fileExtension);
   }

   public String extract(InputStream is) {
      try {
         PDDocument pdfDocument = PDDocument.load(is);
         Throwable var3 = null;

         String var5;
         try {
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setSortByPosition(true);
            var5 = stripper.getText(pdfDocument);
         } catch (Throwable var15) {
            var3 = var15;
            throw var15;
         } finally {
            if (pdfDocument != null) {
               if (var3 != null) {
                  try {
                     pdfDocument.close();
                  } catch (Throwable var14) {
                     var3.addSuppressed(var14);
                  }
               } else {
                  pdfDocument.close();
               }
            }

         }

         return var5;
      } catch (IOException var17) {
         throw new FileException(var17);
      }
   }
}
