/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.text.impl;

import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.io.excel.ExcelHelper;
import net.sinodawn.framework.io.text.FileToTextExtractor;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelFileToTextFullExtractor implements FileToTextExtractor {
   public static final ExcelFileToTextFullExtractor instance = new ExcelFileToTextFullExtractor();

   public boolean match(String fileExtension) {
      return "xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension);
   }

   public String extract(InputStream is) {
      try {
         Workbook wb = WorkbookFactory.create(is);
         Throwable var3 = null;

         String var25;
         try {
            int sheetNum = wb.getNumberOfSheets();
            StringBuilder sb = new StringBuilder();

            for(int sheetNo = 0; sheetNo < sheetNum; ++sheetNo) {
               Sheet sheet = wb.getSheetAt(sheetNo);
               if (!wb.isSheetHidden(sheetNo)) {
                  sb.append("sheetName:").append(sheet.getSheetName()).append("\r\n");
                  int endRowNum = sheet.getLastRowNum() + 1;

                  for(int rowNum = sheet.getFirstRowNum(); rowNum <= endRowNum; ++rowNum) {
                     Row row = sheet.getRow(rowNum);
                     if (row != null) {
                        for(int cellIndex = row.getFirstCellNum(); cellIndex >= 0 && cellIndex <= row.getLastCellNum(); ++cellIndex) {
                           Cell cell = row.getCell(cellIndex);
                           String value = (String)ExcelHelper.getCellValue(cell, String.class);
                           if ("".equals(value)) {
                              value = "\t";
                           }

                           sb.append(" ").append(value);
                        }

                        sb.append("\r\n");
                     }
                  }
               }
            }

            var25 = sb.toString();
         } catch (Throwable var22) {
            var3 = var22;
            throw var22;
         } finally {
            if (wb != null) {
               if (var3 != null) {
                  try {
                     wb.close();
                  } catch (Throwable var21) {
                     var3.addSuppressed(var21);
                  }
               } else {
                  wb.close();
               }
            }

         }

         return var25;
      } catch (IOException var24) {
         throw new FileException(var24);
      }
   }
}
