/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.text.impl;

import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.io.text.FileToTextExtractor;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class DocxFileToTextExtractor implements FileToTextExtractor {
   public static final DocxFileToTextExtractor instance = new DocxFileToTextExtractor();

   public boolean match(String fileExtension) {
      return "docx".equalsIgnoreCase(fileExtension);
   }

   public String extract(InputStream is) {
      try {
         XWPFDocument xdoc = new XWPFDocument(is);
         Throwable var3 = null;

         Object var6;
         try {
            XWPFWordExtractor extractor = new XWPFWordExtractor(xdoc);
            Throwable var5 = null;

            try {
               var6 = extractor.getText();
            } catch (Throwable var31) {
               var6 = var31;
               var5 = var31;
               throw var31;
            } finally {
               if (extractor != null) {
                  if (var5 != null) {
                     try {
                        extractor.close();
                     } catch (Throwable var30) {
                        var5.addSuppressed(var30);
                     }
                  } else {
                     extractor.close();
                  }
               }

            }
         } catch (Throwable var33) {
            var3 = var33;
            throw var33;
         } finally {
            if (xdoc != null) {
               if (var3 != null) {
                  try {
                     xdoc.close();
                  } catch (Throwable var29) {
                     var3.addSuppressed(var29);
                  }
               } else {
                  xdoc.close();
               }
            }

         }

         return (String)var6;
      } catch (IOException var35) {
         throw new FileException(var35);
      }
   }
}
