/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.text.impl;

import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.io.text.FileToTextExtractor;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hwpf.extractor.WordExtractor;

public class DocFileToTextExtractor implements FileToTextExtractor {
   public static final DocFileToTextExtractor instance = new DocFileToTextExtractor();

   public boolean match(String fileExtension) {
      return "doc".equalsIgnoreCase(fileExtension);
   }

   public String extract(InputStream is) {
      try {
         WordExtractor we = new WordExtractor(is);
         Throwable var3 = null;

         String var4;
         try {
            var4 = we.getText();
         } catch (Throwable var14) {
            var3 = var14;
            throw var14;
         } finally {
            if (we != null) {
               if (var3 != null) {
                  try {
                     we.close();
                  } catch (Throwable var13) {
                     var3.addSuppressed(var13);
                  }
               } else {
                  we.close();
               }
            }

         }

         return var4;
      } catch (IOException var16) {
         throw new FileException(var16);
      }
   }
}
