/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.text.impl;

import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.io.text.FileToTextExtractor;
import net.sinodawn.framework.utils.EncodingUtils;
import net.sinodawn.framework.utils.FileUtils;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CsvFileToTextExtractor implements FileToTextExtractor {
   public static final CsvFileToTextExtractor instance = new CsvFileToTextExtractor();

   public boolean match(String fileExtension) {
      return "csv".equalsIgnoreCase(fileExtension);
   }

   public String extract(File file) {
      try {
         DataInputStream din = new DataInputStream(new FileInputStream(file));
         Throwable var3 = null;

         try {
            InputStreamReader isr = new InputStreamReader(din, EncodingUtils.detect(file));
            Throwable var5 = null;

            try {
               BufferedReader br = new BufferedReader(isr);
               Throwable var7 = null;

               try {
                  StringBuilder sb = new StringBuilder();
                  String line = null;

                  while((line = br.readLine()) != null) {
                     sb.append(line).append("\r\n");
                  }

                  String var10 = sb.toString();
                  return var10;
               } catch (Throwable var57) {
                  var7 = var57;
                  throw var57;
               } finally {
                  if (br != null) {
                     if (var7 != null) {
                        try {
                           br.close();
                        } catch (Throwable var56) {
                           var7.addSuppressed(var56);
                        }
                     } else {
                        br.close();
                     }
                  }

               }
            } catch (Throwable var59) {
               var5 = var59;
               throw var59;
            } finally {
               if (isr != null) {
                  if (var5 != null) {
                     try {
                        isr.close();
                     } catch (Throwable var55) {
                        var5.addSuppressed(var55);
                     }
                  } else {
                     isr.close();
                  }
               }

            }
         } catch (Throwable var61) {
            var3 = var61;
            throw var61;
         } finally {
            if (din != null) {
               if (var3 != null) {
                  try {
                     din.close();
                  } catch (Throwable var54) {
                     var3.addSuppressed(var54);
                  }
               } else {
                  din.close();
               }
            }

         }
      } catch (Exception var63) {
         throw new FileException(var63);
      }
   }

   public String extract(InputStream is) {
      File temp = null;

      String var3;
      try {
         temp = FileUtils.createTempFile();
         var3 = this.extract(temp);
      } finally {
         FileUtils.deleteQuietly(temp);
      }

      return var3;
   }
}
