/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.text;

import net.sinodawn.framework.cache.memory.MemoryCacheManager;
import net.sinodawn.framework.io.text.impl.ExcelFileToTextExtractor;
import net.sinodawn.framework.io.text.impl.ExcelFileToTextFullExtractor;
import net.sinodawn.framework.utils.ClassUtils;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public abstract class FileToTextExtractorFactory {
   public static final FileToTextExtractor getFileToTextExtractor(String fileExtension) {
      Iterator var1 = getTextExtractorList().iterator();

      FileToTextExtractor textExtractor;
      do {
         if (!var1.hasNext()) {
            return null;
         }

         textExtractor = (FileToTextExtractor)var1.next();
      } while(ExcelFileToTextFullExtractor.class.equals(textExtractor.getClass()) || !textExtractor.match(fileExtension));

      return textExtractor;
   }

   public static final FileToTextExtractor getFileToFullTextExtractor(String fileExtension) {
      Iterator var1 = getTextExtractorList().iterator();

      FileToTextExtractor textExtractor;
      do {
         if (!var1.hasNext()) {
            return null;
         }

         textExtractor = (FileToTextExtractor)var1.next();
      } while(ExcelFileToTextExtractor.class.equals(textExtractor.getClass()) || !textExtractor.match(fileExtension));

      return textExtractor;
   }

   private static final List<FileToTextExtractor> getTextExtractorList() {
      List<FileToTextExtractor> textExtractorList = (List)MemoryCacheManager.get("FileToTextExtractorList");
      if (textExtractorList == null) {
         Class var1 = FileToTextExtractorFactory.class;
         synchronized(FileToTextExtractorFactory.class) {
            textExtractorList = (List)MemoryCacheManager.get("FileToTextExtractorList");
            if (textExtractorList == null) {
               textExtractorList = (List)ClassUtils.getPredicatedClasses(FileToTextExtractorFactory.class.getPackage().getName(), (c) -> {
                  return FileToTextExtractor.class.isAssignableFrom(c);
               }).stream().filter((c) -> {
                  return !c.isInterface();
               }).map((c) -> {
                  return (FileToTextExtractor)ClassUtils.newInstance(c);
               }).collect(Collectors.toList());
               MemoryCacheManager.put("FileToTextExtractorList", textExtractorList);
            }
         }
      }

      return textExtractorList;
   }
}
