/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.text;

import net.sinodawn.framework.exception.FileException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public interface FileToTextExtractor {
   boolean match(String fileExtension);

   String extract(InputStream is);

   default String extract(File file) {
      try {
         InputStream is = new BufferedInputStream(new FileInputStream(file));
         Throwable var3 = null;

         String var4;
         try {
            var4 = this.extract((InputStream)is);
         } catch (Throwable var14) {
            var3 = var14;
            throw var14;
         } finally {
            if (is != null) {
               if (var3 != null) {
                  try {
                     is.close();
                  } catch (Throwable var13) {
                     var3.addSuppressed(var13);
                  }
               } else {
                  is.close();
               }
            }

         }

         return var4;
      } catch (IOException var16) {
         throw new FileException(var16);
      }
   }

   default String extract(Path path) {
      return this.extract(path.toFile());
   }
}
