/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.file;

import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.SystemUtils;
import net.sinodawn.module.item.file.utils.CoreFileUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FilePathManager {
   public static final String FILE_ROOT_DIR_NAME = "files";
   private static Path applicationFileRootPath;

   public static final Path getApplicationRootPath() {
      if (applicationFileRootPath == null) {
         Class var0 = CoreFileUtils.class;
         synchronized(CoreFileUtils.class) {
            if (applicationFileRootPath == null) {
               applicationFileRootPath = SystemUtils.getWorkingPath();
            }
         }
      }

      return applicationFileRootPath;
   }

   public static final Path getApplicationFilePath() {
      return getApplicationRootPath().resolve("files");
   }

   public static final Path getLocalPath(FileScope fileScope) {
      return getApplicationFilePath().resolve(fileScope.name());
   }

   public static final Path getLocalPath(Path relativeFilePath) {
      return getApplicationRootPath().resolve(relativeFilePath);
   }

   public static final Path getLocalPath(FilePathDTO filePath) {
      return getLocalDirPath(filePath).resolve(filePath.getFileName());
   }

   public static final Path getLocalDirPath(FilePathDTO filePath) {
      Path path = getApplicationFilePath().resolve(filePath.getScope().name());
      if (!FileScope.finereport.equals(filePath.getScope()) && !StringUtils.isBlank(filePath.getTimestamp())) {
         path = path.resolve(filePath.getTimestamp());
      }

      return path.resolve(filePath.getIrregularName());
   }

   public static final String getUrl(FilePathDTO filePath) {
      StringBuilder sb = (new StringBuilder("/")).append("files").append("/").append(filePath.getScope().name()).append("/");
      if (!FileScope.finereport.equals(filePath.getScope()) && !StringUtils.isBlank(filePath.getTimestamp())) {
         sb.append(filePath.getTimestamp()).append("/");
      }

      return sb.append(filePath.getIrregularName()).append("/").append(filePath.getFileName()).toString();
   }

   public static final FilePathDTO toFilePath(String downloadUri) {
      String[] values = StringUtils.split(StringUtils.decodeURL(downloadUri), "/");
      if (values.length == 6) {
         return FilePathDTO.of(values[2], values[3], values[4], values[5]);
      } else {
         return values.length == 5 ? FilePathDTO.of(values[2], "", values[3], values[4]) : null;
      }
   }

   public static final Path getRelativePath(Path fileAbsolutePath) {
      List<String> nameList = new ArrayList();
      fileAbsolutePath.spliterator().forEachRemaining((p) -> {
         nameList.add(p.toString());
      });
      List<String> selectedNameList = new ArrayList();

      for(int i = nameList.size() - 1; i >= 0; --i) {
         String name = (String)nameList.get(i);
         if (i < nameList.size() - 2 && "files".equals(name)) {
            break;
         }

         selectedNameList.add(0, name);
      }

      Path relativePath = Paths.get("files");

      String selectedName;
      for(Iterator var7 = selectedNameList.iterator(); var7.hasNext(); relativePath = relativePath.resolve(selectedName)) {
         selectedName = (String)var7.next();
      }

      return relativePath;
   }
}
