/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.excel.support.impl;

import net.sinodawn.framework.io.excel.support.PropertyContext;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class DefaultPropertyContextImpl implements PropertyContext {
   private String title;
   private String name;
   private HorizontalAlignment alignment;
   private BiConsumer<Cell, Object> styleConsumer;
   private Function<Object, Object> function;
   private boolean numeric = false;
   private BiConsumer<Cell, Object> cellRowItemConsumer;

   public static PropertyContext of(String title, String name) {
      return new DefaultPropertyContextImpl(title, name, (Function)null, (HorizontalAlignment)null);
   }

   public static PropertyContext of(String title, String name, HorizontalAlignment alignment) {
      return new DefaultPropertyContextImpl(title, name, (Function)null, alignment);
   }

   public static PropertyContext of(String title, String name, Function<Object, Object> function) {
      return new DefaultPropertyContextImpl(title, name, function, (HorizontalAlignment)null);
   }

   public static PropertyContext of(String title, String name, Function<Object, Object> function, HorizontalAlignment alignment) {
      return new DefaultPropertyContextImpl(title, name, function, alignment);
   }

   private DefaultPropertyContextImpl(String title, String name, Function<Object, Object> function, HorizontalAlignment alignment) {
      this.title = title;
      this.name = name;
      this.function = (Function)Optional.ofNullable(function).orElse((v) -> {
         return v;
      });
      this.alignment = (HorizontalAlignment)Optional.ofNullable(alignment).orElse(HorizontalAlignment.CENTER);
   }

   public String getTitle() {
      return this.title;
   }

   public String getName() {
      return this.name;
   }

   public Function<Object, Object> getConvertFunction() {
      return this.function;
   }

   public HorizontalAlignment getAlignment() {
      return this.alignment;
   }

   public BiConsumer<Cell, Object> getCellRowItemConsumer() {
      return this.cellRowItemConsumer;
   }

   public void setCellRowItemConsumer(BiConsumer<Cell, Object> cellRowItemConsumer) {
      this.cellRowItemConsumer = cellRowItemConsumer;
   }

   public BiConsumer<Cell, Object> getStyleConsumer() {
      return this.styleConsumer;
   }

   public void setStyleConsumer(BiConsumer<Cell, Object> styleConsumer) {
      this.styleConsumer = styleConsumer;
   }

   public boolean isNumeric() {
      return this.numeric;
   }

   public void setNumeric(boolean numeric) {
      this.numeric = numeric;
   }
}
