/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.excel.support;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public interface PropertyContext {
   String getTitle();

   String getName();

   HorizontalAlignment getAlignment();

   Function<Object, Object> getConvertFunction();

   void setCellRowItemConsumer(BiConsumer<Cell, Object> rowItemConsumer);

   BiConsumer<Cell, Object> getCellRowItemConsumer();

   void setStyleConsumer(BiConsumer<Cell, Object> styleConsumer);

   BiConsumer<Cell, Object> getStyleConsumer();

   boolean isNumeric();

   void setNumeric(boolean numeric);
}
