/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.excel.impl;

import net.sinodawn.framework.exception.UnexpectedException;
import net.sinodawn.framework.io.excel.BaseExcelWriter;
import net.sinodawn.framework.io.excel.SheetWriter;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.IOException;
import java.io.OutputStream;

public class DefaultExcelWriter extends BaseExcelWriter {
   public DefaultExcelWriter(SheetWriter... sheetWriters) {
      super(sheetWriters);
   }

   public void write(OutputStream out) {
      try {
         SXSSFWorkbook wb = new SXSSFWorkbook((XSSFWorkbook)null, 100, false, true);

         try {
            SheetWriter[] var3 = this.getSheetWriters();
            int var4 = var3.length;

            for(int var5 = 0; var5 < var4; ++var5) {
               SheetWriter sheetWriter = var3[var5];
               sheetWriter.write(wb);
            }

            wb.write(out);
         } finally {
            if (wb != null) {
               try {
                  wb.dispose();
               } catch (Exception var16) {
               }

               try {
                  wb.close();
               } catch (Exception var15) {
               }
            }

         }
      } catch (IOException var18) {
         throw new UnexpectedException(var18);
      }
   }
}
