/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.io.excel;

import net.sinodawn.framework.io.excel.support.SheetContext;
import java.util.List;

public abstract class BaseSheetWriter implements SheetWriter {
   private final SheetContext sheetContext;
   private final List<? extends Object> items;
   private final Class<? extends Object> itemClass;

   public BaseSheetWriter(SheetContext sheetContext, List<? extends Object> items) {
      this.sheetContext = sheetContext;
      this.items = items;
      if (items.isEmpty()) {
         this.itemClass = Object.class;
      } else {
         this.itemClass = items.get(0).getClass();
      }

   }

   public SheetContext getSheetContext() {
      return this.sheetContext;
   }

   public List<? extends Object> getItems() {
      return this.items;
   }

   public Class<? extends Object> getItemClass() {
      return this.itemClass;
   }
}
