/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.id;


import java.time.Instant;

class SnowflakeIdWorker {
    private final long workerIdBits = 8L;
    private final long sequenceBits = 5L;
    private final long maxSequence = 31L;
    private final long maxWorkerUd = 255L;
    private final long timestampShift = 13L;
    private final long workerIdShift = 5L;
    private final long epoch = 1546214400000L;
    private final long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private long lastId = 0L;

    public SnowflakeIdWorker(long workerId) {
        if (workerId > 255L) {
            workerId = 0L;
        }

        this.workerId = workerId == 0L ? Instant.now().toEpochMilli() % 255L : workerId;
    }

    public synchronized long nextId() {
        long currTimestamp = this.timestampGen();
        long nextId;
        if (currTimestamp < this.lastTimestamp) {
            nextId = this.lastTimestamp - currTimestamp;
            if (nextId > 1000L) {
                throw new IllegalArgumentException(String.format("last timestamp %d can't be greater than current timestamp %d", this.lastTimestamp, currTimestamp));
            }

            while(currTimestamp < this.lastTimestamp) {
                currTimestamp = this.timestampGen();
            }
        }

        if (currTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 31L;
            if (this.sequence == 0L) {
                currTimestamp = this.waitNextMillis(currTimestamp);
            }
        } else {
            this.sequence = 0L;
        }

        this.lastTimestamp = currTimestamp;
        nextId = currTimestamp - 1546214400000L << 13 | this.workerId << 5 | this.sequence;
        if (nextId <= this.lastId) {
            try {
                Thread.sleep(1L);
            } catch (InterruptedException ignored) {
            }

            return this.nextId();
        } else {
            return this.lastId = nextId;
        }
    }

    protected long waitNextMillis(long currTimestamp) {
        while(currTimestamp <= this.lastTimestamp) {
            currTimestamp = this.timestampGen();
        }

        return currTimestamp;
    }

    protected long timestampGen() {
        return System.currentTimeMillis();
    }

    public long getEpoch() {
        this.getClass();
        return 1546214400000L;
    }
}
