/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.id;

public class SinoIdHelper {
    private static SnowflakeIdWorker worker;

    public SinoIdHelper() {
    }

    public static synchronized void init(long workerId) {
        if (worker == null) {
            worker = new SnowflakeIdWorker(workerId);
        }

    }

    public static final long nextId() {
        if (worker == null) {
            init(0L);
        }

        return worker.nextId();
    }

    public static final String nextStringId() {
        return Long.toString(nextId());
    }
}

