/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.i18n;

import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class DatabaseDrivenMessageSource implements MessageSource {
   public DatabaseDrivenMessageSource(ApplicationContext applicationContext) {
   }

   public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
      return (String)Optional.ofNullable(this.resolveMessage(code, args, locale)).orElse(defaultMessage);
   }

   public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
      return this.resolveMessage(code, args, locale);
   }

   public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
      String[] var3 = resolvable.getCodes();
      int var4 = var3.length;

      for(int var5 = 0; var5 < var4; ++var5) {
         String code = var3[var5];
         String message = this.resolveMessage(code, resolvable.getArguments(), locale);
         if (message != null) {
            return message;
         }
      }

      return null;
   }

   private String resolveMessage(String code, Object[] args, Locale locale) {
      StringBuilder sb = new StringBuilder(locale.getLanguage().toLowerCase());
      if (!StringUtils.isBlank(locale.getCountry())) {
         sb.append("-").append(locale.getCountry().toLowerCase());
      }

      String localeCode = sb.toString();
//      Map<String, String> messageMap = CoreI18nCache.instance().getI18nLocaleMap(localeCode);
      Map<String, String> messageMap = new HashMap<>();
      if (messageMap != null) {
         String message = (String)messageMap.get(code);
         if (message != null) {
            if (ArrayUtils.isEmpty(args)) {
               return message;
            }

            return MessageFormat.format(message, args);
         }
      }

      return code;
   }
}
