/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.http;

import net.sinodawn.framework.exception.UnexpectedException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class HttpsSimpleClient extends BaseHttpClient {
   private static HttpsSimpleClient instance;

   private HttpsSimpleClient() {
   }

   public static final HttpsSimpleClient getInstance() {
      if (instance == null) {
         Class var0 = HttpsSimpleClient.class;
         synchronized(HttpsSimpleClient.class) {
            if (instance == null) {
               instance = new HttpsSimpleClient();
            }
         }
      }

      return instance;
   }

   CloseableHttpClient getHttpClient() {
      try {
         SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((KeyStore)null, new TrustStrategy() {
            public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
               return true;
            }
         }).build();
         return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier(new NoopHostnameVerifier()).build();
      } catch (NoSuchAlgorithmException | KeyStoreException | KeyManagementException var2) {
         throw new UnexpectedException(var2);
      }
   }
}
