/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.http;

import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.net.ssl.SSLContext;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class HttpSimpleClient extends BaseHttpClient {
   private static final Logger logger = LogManager.getLogger(HttpSimpleClient.class);
   private static HttpSimpleClient instance;

   private HttpSimpleClient() {
   }

   public static final HttpSimpleClient getInstance() {
      if (instance == null) {
         Class var0 = HttpSimpleClient.class;
         synchronized(HttpSimpleClient.class) {
            if (instance == null) {
               instance = new HttpSimpleClient();
            }
         }
      }

      return instance;
   }

   public CloseableHttpClient getHttpClient() {
      try {
         SSLContext sslContext = (new SSLContextBuilder()).loadTrustMaterial((KeyStore)null, new TrustStrategy() {
            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
               return true;
            }
         }).build();
         SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslContext);
         return HttpClients.custom().setDefaultRequestConfig(this.getDefaultRequestConfig()).setSSLSocketFactory(sslFactory).build();
      } catch (Exception var3) {
         logger.warn("TRUST ALL CERTS EXCEPTION");
         return HttpClients.custom().setDefaultRequestConfig(this.getDefaultRequestConfig()).build();
      }
   }
}
