/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.http;

import net.sinodawn.framework.utils.StringUtils;
import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.InputStream;

public class HttpClientManager implements HttpClientInterface {
   private static HttpClientManager instance;

   private HttpClientManager() {
   }

   public static HttpClientManager getInstance() {
      if (instance == null) {
         Class var0 = HttpClientManager.class;
         synchronized(HttpClientManager.class) {
            if (instance == null) {
               instance = new HttpClientManager();
            }
         }
      }

      return instance;
   }

   public String sendHttpGet(String url) {
      return this.getClient(url).sendHttpGet(url);
   }

   public String sendHttpPost(String url, String jsonString) {
      return this.getClient(url).sendHttpPost(url, jsonString);
   }

   public String sendHttpPut(String url, String jsonString) {
      return this.getClient(url).sendHttpPut(url, jsonString);
   }

   public String sendHttpDelete(String url) {
      return this.getClient(url).sendHttpDelete(url);
   }

   public String upload(String targetUrl, MultipartFile multipartFile) {
      return this.getClient(targetUrl).upload(targetUrl, multipartFile);
   }

   public String upload(String targetUrl, File file) {
      return this.getClient(targetUrl).upload(targetUrl, file);
   }

   public String upload(String targetUrl, String fileName, InputStream is) {
      return this.getClient(targetUrl).upload(targetUrl, fileName, is);
   }

   public String upload(String targetUrl, String fileName, String sourceUrl) {
      return this.getClient(targetUrl).upload(targetUrl, fileName, sourceUrl);
   }

   public <T> String upload(String targetUrl, MultipartFile multipartFile, @Nullable T param) {
      return this.getClient(targetUrl).upload(targetUrl, multipartFile, param);
   }

   public <T> String upload(String targetUrl, File file, @Nullable T param) {
      return this.getClient(targetUrl).upload(targetUrl, file, param);
   }

   public <T> String upload(String targetUrl, String fileName, InputStream is, @Nullable T param) {
      return this.getClient(targetUrl).upload(targetUrl, fileName, is, param);
   }

   public <T> String upload(String targetUrl, String fileName, String sourceUrl, @Nullable T param) {
      return this.getClient(targetUrl).upload(targetUrl, fileName, sourceUrl, param);
   }

   public void download(String sourceUrl, String targetPath) {
      this.getClient(sourceUrl).download(sourceUrl, targetPath);
   }

   public void download(String sourceUrl, File targetFile) {
      this.getClient(sourceUrl).download(sourceUrl, targetFile);
   }

   public InputStream download(String url) {
      return this.getClient(url).download(url);
   }

   private HttpClientInterface getClient(String url) {
      return (HttpClientInterface)(StringUtils.startsWithIgnoreCase(url, "https:") ? HttpsSimpleClient.getInstance() : HttpSimpleClient.getInstance());
   }
}
