/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.http;

import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.InputStream;

public interface HttpClientInterface {
   String sendHttpGet(String url);

   String sendHttpPost(String url, String jsonString);

   String sendHttpPut(String url, String jsonString);

   String sendHttpDelete(String url);

   String upload(String targetUrl, MultipartFile multipartFile);

   String upload(String targetUrl, File file);

   String upload(String targetUrl, String fileName, InputStream is);

   String upload(String targetUrl, String fileName, String sourceUrl);

   <T> String upload(String targetUrl, MultipartFile multipartFile, @Nullable T param);

   <T> String upload(String targetUrl, File file, @Nullable T param);

   <T> String upload(String targetUrl, String fileName, InputStream is, @Nullable T param);

   <T> String upload(String targetUrl, String fileName, String sourceUrl, @Nullable T param);

   void download(String sourceUrl, String targetPath);

   void download(String sourceUrl, File targetFile);

   InputStream download(String url);
}
