/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.http;

import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.beans.BeanPropertyHelper;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.exception.FileException;
import net.sinodawn.framework.exception.NetworkException;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.FileUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.*;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;

public abstract class BaseHttpClient implements HttpClientInterface {
   private static final String DEFAULT_CHARSET_NAME = "UTF-8";

   abstract CloseableHttpClient getHttpClient();

   protected RequestConfig getDefaultRequestConfig() {
      return RequestConfig.custom().setSocketTimeout((Integer)ApplicationContextHelper.getEnvironment().getProperty("sino.http-client.socket-timeout", Integer.class, 30000)).setConnectTimeout((Integer)ApplicationContextHelper.getEnvironment().getProperty("sino.http-client.connect-timeout", Integer.class, 3000)).build();
   }

   public final String sendHttpGet(String url) {
      try {
         CloseableHttpClient httpClient = this.getHttpClient();
         Throwable var3 = null;

         String var8;
         try {
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute(httpGet);
            Throwable var6 = null;

            try {
               HttpEntity body = response.getEntity();
               var8 = EntityUtils.toString(body, "UTF-8");
            } catch (Throwable var33) {
               var6 = var33;
               throw var33;
            } finally {
               if (response != null) {
                  if (var6 != null) {
                     try {
                        response.close();
                     } catch (Throwable var32) {
                        var6.addSuppressed(var32);
                     }
                  } else {
                     response.close();
                  }
               }

            }
         } catch (Throwable var35) {
            var3 = var35;
            throw var35;
         } finally {
            if (httpClient != null) {
               if (var3 != null) {
                  try {
                     httpClient.close();
                  } catch (Throwable var31) {
                     var3.addSuppressed(var31);
                  }
               } else {
                  httpClient.close();
               }
            }

         }

         return var8;
      } catch (IOException var37) {
         throw new NetworkException(var37);
      }
   }

   public final String sendHttpPost(String url, String jsonString) {
      try {
         CloseableHttpClient httpClient = this.getHttpClient();
         Throwable var4 = null;

         String var10;
         try {
            if (jsonString == null) {
               jsonString = "";
            }

            StringEntity postEntity = new StringEntity(jsonString, "UTF-8");
            postEntity.setContentEncoding("UTF-8");
            postEntity.setContentType("application/json");
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(postEntity);
            CloseableHttpResponse response = httpClient.execute(httpPost);
            Throwable var8 = null;

            try {
               HttpEntity body = response.getEntity();
               var10 = EntityUtils.toString(body, "UTF-8");
            } catch (Throwable var35) {
               var8 = var35;
               throw var35;
            } finally {
               if (response != null) {
                  if (var8 != null) {
                     try {
                        response.close();
                     } catch (Throwable var34) {
                        var8.addSuppressed(var34);
                     }
                  } else {
                     response.close();
                  }
               }

            }
         } catch (Throwable var37) {
            var4 = var37;
            throw var37;
         } finally {
            if (httpClient != null) {
               if (var4 != null) {
                  try {
                     httpClient.close();
                  } catch (Throwable var33) {
                     var4.addSuppressed(var33);
                  }
               } else {
                  httpClient.close();
               }
            }

         }

         return var10;
      } catch (IOException var39) {
         throw new NetworkException(var39);
      }
   }

   public final String sendHttpPut(String url, String jsonString) {
      try {
         CloseableHttpClient httpClient = this.getHttpClient();
         Throwable var4 = null;

         String var10;
         try {
            if (jsonString == null) {
               jsonString = "";
            }

            StringEntity postEntity = new StringEntity(jsonString, "UTF-8");
            postEntity.setContentEncoding("UTF-8");
            postEntity.setContentType("application/json");
            HttpPut httpPut = new HttpPut(url);
            httpPut.setEntity(postEntity);
            CloseableHttpResponse response = httpClient.execute(httpPut);
            Throwable var8 = null;

            try {
               HttpEntity body = response.getEntity();
               var10 = EntityUtils.toString(body, "UTF-8");
            } catch (Throwable var35) {
               var8 = var35;
               throw var35;
            } finally {
               if (response != null) {
                  if (var8 != null) {
                     try {
                        response.close();
                     } catch (Throwable var34) {
                        var8.addSuppressed(var34);
                     }
                  } else {
                     response.close();
                  }
               }

            }
         } catch (Throwable var37) {
            var4 = var37;
            throw var37;
         } finally {
            if (httpClient != null) {
               if (var4 != null) {
                  try {
                     httpClient.close();
                  } catch (Throwable var33) {
                     var4.addSuppressed(var33);
                  }
               } else {
                  httpClient.close();
               }
            }

         }

         return var10;
      } catch (IOException var39) {
         throw new NetworkException(var39);
      }
   }

   public final String sendHttpDelete(String url) {
      try {
         CloseableHttpClient httpClient = this.getHttpClient();
         Throwable var3 = null;

         String var8;
         try {
            HttpDelete httpDelete = new HttpDelete(url);
            CloseableHttpResponse response = httpClient.execute(httpDelete);
            Throwable var6 = null;

            try {
               HttpEntity body = response.getEntity();
               var8 = EntityUtils.toString(body, "UTF-8");
            } catch (Throwable var33) {
               var6 = var33;
               throw var33;
            } finally {
               if (response != null) {
                  if (var6 != null) {
                     try {
                        response.close();
                     } catch (Throwable var32) {
                        var6.addSuppressed(var32);
                     }
                  } else {
                     response.close();
                  }
               }

            }
         } catch (Throwable var35) {
            var3 = var35;
            throw var35;
         } finally {
            if (httpClient != null) {
               if (var3 != null) {
                  try {
                     httpClient.close();
                  } catch (Throwable var31) {
                     var3.addSuppressed(var31);
                  }
               } else {
                  httpClient.close();
               }
            }

         }

         return var8;
      } catch (IOException var37) {
         throw new NetworkException(var37);
      }
   }

   public final String upload(String targetUrl, MultipartFile multipartFile) {
      return this.upload(targetUrl, (MultipartFile)multipartFile, null);
   }

   public final String upload(String targetUrl, File file) {
      return this.upload(targetUrl, (File)file, null);
   }

   public final String upload(String targetUrl, String fileName, InputStream is) {
      return this.upload(targetUrl, fileName, (InputStream)is, null);
   }

   public final String upload(String targetUrl, String fileName, String sourceUrl) {
      return this.upload(targetUrl, fileName, (String)sourceUrl, null);
   }

   public final <T> String upload(String targetUrl, MultipartFile multipartFile, @Nullable T item) {
      MultipartEntityBuilder builder = MultipartEntityBuilder.create();

      try {
         builder.addBinaryBody("file", multipartFile.getInputStream(), ContentType.DEFAULT_BINARY, this.getOriginalFilename(multipartFile.getOriginalFilename()));
      } catch (IOException var10) {
         throw new FileException(var10);
      }

      if (item != null) {
         List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass());
         Iterator var6 = propertyDescriptorList.iterator();

         while(var6.hasNext()) {
            BeanPropertyDescriptor propertyDescriptor = (BeanPropertyDescriptor)var6.next();
            Object value = propertyDescriptor.getPropertyValue(item);
            if (value != null && ConvertUtils.canConvert(value, String.class)) {
               String strValue = (String)ConvertUtils.convert(value, String.class);
               if (!StringUtils.isBlank(strValue)) {
                  builder.addPart(propertyDescriptor.getName(), new StringBody(strValue, ContentType.create("text/plain", Consts.UTF_8)));
               }
            }
         }
      }

      return this.upload(targetUrl, builder);
   }

   public final <T> String upload(String targetUrl, File file, @Nullable T item) {
      MultipartEntityBuilder builder = MultipartEntityBuilder.create();
      builder.addBinaryBody("file", file);
      if (item != null) {
         List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass());
         Iterator var6 = propertyDescriptorList.iterator();

         while(var6.hasNext()) {
            BeanPropertyDescriptor propertyDescriptor = (BeanPropertyDescriptor)var6.next();
            Object value = propertyDescriptor.getPropertyValue(item);
            if (value != null && ConvertUtils.canConvert(value, String.class)) {
               String strValue = (String)ConvertUtils.convert(value, String.class);
               if (!StringUtils.isBlank(strValue)) {
                  builder.addPart(propertyDescriptor.getName(), new StringBody(strValue, ContentType.create("text/plain", Consts.UTF_8)));
               }
            }
         }
      }

      return this.upload(targetUrl, builder);
   }

   public final <T> String upload(String targetUrl, String fileName, InputStream is, @Nullable T item) {
      MultipartEntityBuilder builder = MultipartEntityBuilder.create();
      builder.addBinaryBody("file", is, ContentType.DEFAULT_BINARY, fileName);
      if (item != null) {
         List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass());
         Iterator var7 = propertyDescriptorList.iterator();

         while(var7.hasNext()) {
            BeanPropertyDescriptor propertyDescriptor = (BeanPropertyDescriptor)var7.next();
            Object value = propertyDescriptor.getPropertyValue(item);
            if (value != null && ConvertUtils.canConvert(value, String.class)) {
               String strValue = (String)ConvertUtils.convert(value, String.class);
               if (!StringUtils.isBlank(strValue)) {
                  builder.addPart(propertyDescriptor.getName(), new StringBody(strValue, ContentType.create("text/plain", Consts.UTF_8)));
               }
            }
         }
      }

      return this.upload(targetUrl, builder);
   }

   public final <T> String upload(String targetUrl, String fileName, String sourceUrl, @Nullable T item) {
      MultipartEntityBuilder builder = MultipartEntityBuilder.create();

      try {
         CloseableHttpClient httpClient = this.getHttpClient();
         Throwable var7 = null;

         String var45;
         try {
            HttpGet httpGet = new HttpGet(sourceUrl);
            CloseableHttpResponse response = httpClient.execute(httpGet);
            Throwable var10 = null;

            try {
               InputStream is = response.getEntity().getContent();
               builder.addBinaryBody("file", is, ContentType.DEFAULT_BINARY, fileName);
               if (item != null) {
                  List<BeanPropertyDescriptor> propertyDescriptorList = BeanPropertyHelper.getBeanPropertyDescriptorList(item.getClass());
                  Iterator var13 = propertyDescriptorList.iterator();

                  while(var13.hasNext()) {
                     BeanPropertyDescriptor propertyDescriptor = (BeanPropertyDescriptor)var13.next();
                     Object value = propertyDescriptor.getPropertyValue(item);
                     if (value != null && ConvertUtils.canConvert(value, String.class)) {
                        String strValue = (String)ConvertUtils.convert(value, String.class);
                        if (!StringUtils.isBlank(strValue)) {
                           builder.addPart(propertyDescriptor.getName(), new StringBody(strValue, ContentType.create("text/plain", Consts.UTF_8)));
                        }
                     }
                  }
               }

               var45 = this.upload(targetUrl, builder);
            } catch (Throwable var40) {
               var10 = var40;
               throw var40;
            } finally {
               if (response != null) {
                  if (var10 != null) {
                     try {
                        response.close();
                     } catch (Throwable var39) {
                        var10.addSuppressed(var39);
                     }
                  } else {
                     response.close();
                  }
               }

            }
         } catch (Throwable var42) {
            var7 = var42;
            throw var42;
         } finally {
            if (httpClient != null) {
               if (var7 != null) {
                  try {
                     httpClient.close();
                  } catch (Throwable var38) {
                     var7.addSuppressed(var38);
                  }
               } else {
                  httpClient.close();
               }
            }

         }

         return var45;
      } catch (IOException var44) {
         throw new NetworkException(var44);
      }
   }

   public final void download(String sourceUrl, String targetPath) {
      try {
         CloseableHttpClient httpClient = this.getHttpClient();
         Throwable var4 = null;

         try {
            HttpGet httpGet = new HttpGet(sourceUrl);
            CloseableHttpResponse response = httpClient.execute(httpGet);
            Throwable var7 = null;

            try {
               InputStream is = response.getEntity().getContent();
               File target = new File(targetPath);
               FileUtils.createFile(target);
               FileUtils.write(target, is);
            } catch (Throwable var33) {
               var7 = var33;
               throw var33;
            } finally {
               if (response != null) {
                  if (var7 != null) {
                     try {
                        response.close();
                     } catch (Throwable var32) {
                        var7.addSuppressed(var32);
                     }
                  } else {
                     response.close();
                  }
               }

            }
         } catch (Throwable var35) {
            var4 = var35;
            throw var35;
         } finally {
            if (httpClient != null) {
               if (var4 != null) {
                  try {
                     httpClient.close();
                  } catch (Throwable var31) {
                     var4.addSuppressed(var31);
                  }
               } else {
                  httpClient.close();
               }
            }

         }

      } catch (IOException var37) {
         throw new NetworkException(var37);
      }
   }

   public final void download(String sourceUrl, File targetFile) {
      FileUtils.makeDirs(targetFile.toPath());

      try {
         CloseableHttpClient httpClient = this.getHttpClient();
         Throwable var4 = null;

         try {
            HttpGet httpGet = new HttpGet(sourceUrl);
            CloseableHttpResponse response = httpClient.execute(httpGet);
            Throwable var7 = null;

            try {
               InputStream is = response.getEntity().getContent();
               FileUtils.write(targetFile, is);
            } catch (Throwable var32) {
               var7 = var32;
               throw var32;
            } finally {
               if (response != null) {
                  if (var7 != null) {
                     try {
                        response.close();
                     } catch (Throwable var31) {
                        var7.addSuppressed(var31);
                     }
                  } else {
                     response.close();
                  }
               }

            }
         } catch (Throwable var34) {
            var4 = var34;
            throw var34;
         } finally {
            if (httpClient != null) {
               if (var4 != null) {
                  try {
                     httpClient.close();
                  } catch (Throwable var30) {
                     var4.addSuppressed(var30);
                  }
               } else {
                  httpClient.close();
               }
            }

         }

      } catch (IOException var36) {
         throw new NetworkException(var36);
      }
   }

   public InputStream download(String url) {
      try {
         CloseableHttpClient httpClient = this.getHttpClient();
         Throwable var3 = null;

         Object var7;
         try {
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute(httpGet);
            Throwable var6 = null;

            try {
               var7 = response.getEntity().getContent();
            } catch (Throwable var32) {
               var7 = var32;
               var6 = var32;
               throw var32;
            } finally {
               if (response != null) {
                  if (var6 != null) {
                     try {
                        response.close();
                     } catch (Throwable var31) {
                        var6.addSuppressed(var31);
                     }
                  } else {
                     response.close();
                  }
               }

            }
         } catch (Throwable var34) {
            var3 = var34;
            throw var34;
         } finally {
            if (httpClient != null) {
               if (var3 != null) {
                  try {
                     httpClient.close();
                  } catch (Throwable var30) {
                     var3.addSuppressed(var30);
                  }
               } else {
                  httpClient.close();
               }
            }

         }

         return (InputStream)var7;
      } catch (IOException var36) {
         throw new NetworkException(var36);
      }
   }

   private final String upload(String targetUrl, MultipartEntityBuilder builder) {
      try {
         CloseableHttpClient httpClient = this.getHttpClient();
         Throwable var4 = null;

         String var10;
         try {
            HttpPost httpPost = new HttpPost(targetUrl);
            HttpEntity multipartEntity = builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(StandardCharsets.UTF_8).build();
            httpPost.setEntity(multipartEntity);
            CloseableHttpResponse response = httpClient.execute(httpPost);
            Throwable var8 = null;

            try {
               int statusCode = response.getStatusLine().getStatusCode();
               if (statusCode != 200) {
                  throw new NetworkException(statusCode);
               }

               var10 = EntityUtils.toString(response.getEntity());
            } catch (Throwable var35) {
               var8 = var35;
               throw var35;
            } finally {
               if (response != null) {
                  if (var8 != null) {
                     try {
                        response.close();
                     } catch (Throwable var34) {
                        var8.addSuppressed(var34);
                     }
                  } else {
                     response.close();
                  }
               }

            }
         } catch (Throwable var37) {
            var4 = var37;
            throw var37;
         } finally {
            if (httpClient != null) {
               if (var4 != null) {
                  try {
                     httpClient.close();
                  } catch (Throwable var33) {
                     var4.addSuppressed(var33);
                  }
               } else {
                  httpClient.close();
               }
            }

         }

         return var10;
      } catch (IOException var39) {
         throw new NetworkException(var39);
      }
   }

   private String getOriginalFilename(String filename) {
      int index = filename.lastIndexOf("\\");
      if (index >= 0) {
         return filename.substring(index + 1);
      } else {
         index = filename.lastIndexOf("/");
         return index > 0 ? filename.substring(index + 1) : filename;
      }
   }
}
