/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.exception.advice;

import net.sinodawn.framework.exception.checked.CheckedException;
import net.sinodawn.framework.exception.core.ApplicationWarningException;
import net.sinodawn.framework.exception.core.HttpErrorMessage;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.utils.ServletUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

//import net.sinodawn.framework.i18n.I18nHelper;
//import org.springframework.security.core.AuthenticationException;

// TODO 异常处理
@ControllerAdvice
@RestControllerAdvice
@Order(Integer.MIN_VALUE)
public class GlobalExceptionHandler {
   private static final Logger logger = LogManager.getLogger(GlobalExceptionHandler.class);
   @Value("${sino.exception.viewable}")
   private boolean viewable;

   /** @deprecated */
   @Deprecated
   @ExceptionHandler
   @ResponseStatus(HttpStatus.BAD_REQUEST)
   @Log(
      value = "数据验证异常",
      type = LogType.EXCEPTION
   )
   public void handleCheckedException(CheckedException checkedException) {
//      ServletUtils.responseError(HttpStatus.BAD_REQUEST.value(), I18nHelper.getMessage(checkedException.getMessage()));
   }

   /** @deprecated */
   @Deprecated
   @ExceptionHandler
   @ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
   @Log(
      value = "内部异常",
      type = LogType.EXCEPTION
   )
   public void handleThrowable(Throwable throwable) {
      Class<?> clazz = throwable.getClass();
      ResponseStatus status = (ResponseStatus)clazz.getAnnotation(ResponseStatus.class);
      logger.error(throwable.getMessage(), throwable);
      if (status != null && !status.value().equals(HttpStatus.INTERNAL_SERVER_ERROR)) {
         int statusCode = status.value().value();
         if (HttpStatus.NOT_FOUND.value() == statusCode) {
            statusCode = HttpStatus.INTERNAL_SERVER_ERROR.value();
         }

//         ServletUtils.responseError(statusCode, I18nHelper.getMessage(throwable.getMessage()));
      } else {
//         String message = !AuthenticationException.class.isAssignableFrom(clazz) && (throwable.getCause() != null || !StringUtils.startsWith(throwable.getClass().getName(), "net.sinodawn")) ? I18nHelper.getMessage("SINO.EXCEPTION.UNEXPECTED") : I18nHelper.getMessage(throwable.getMessage());
//         if (this.viewable) {
//            ServletUtils.responseError(HttpErrorMessage.of(HttpStatus.BAD_REQUEST, message, throwable));
//         } else {
//            ServletUtils.responseError(HttpErrorMessage.of(HttpStatus.INTERNAL_SERVER_ERROR, message));
//         }
      }

   }

   @ExceptionHandler
   @ResponseStatus(HttpStatus.BAD_REQUEST)
   @Log(
      value = "数据验证异常",
      type = LogType.EXCEPTION
   )
   public void warningException(ApplicationWarningException warningException) {
      logger.warn(warningException.getMessage(), warningException);
      ServletUtils.responseError(HttpErrorMessage.of(HttpStatus.BAD_REQUEST, warningException.getMessage()));
   }
}
