/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.exception;

import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class QuietHelper {
   private static final Logger logger = LogManager.getLogger(QuietHelper.class);

   public static void call(Runnable runnable) {
      try {
         runnable.run();
      } catch (Exception var2) {
         logger.debug(var2.getMessage(), var2);
      }

   }

   public static <T> T call(Supplier<T> supplier) {
      try {
         return supplier.get();
      } catch (Exception var2) {
         logger.debug(var2.getMessage(), var2);
         return null;
      }
   }
}
