/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.database.dialect;

import net.sinodawn.framework.database.context.ColumnContext;
import net.sinodawn.framework.exception.UnsupportedDataTypeJdbcException;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

public class MysqlDialect implements Dialect{
    public MysqlDialect() {
    }

    @Override
    public String getDatabase() {
        return "mysql";
    }

    @Override
    public String getSelectFromTableSql(String sql) {
        return "SELECT * FROM " + sql;
    }

    @Override
    public String getLimitSql(String sql, int offset, int limit) {
        return limit == 0
                ? "SELECT * FROM (\n" + sql + "\n" + ") S_ LIMIT 0"
                : "SELECT * FROM ( " +
                    "SELECT S_.* FROM (\n"
                        + sql + "\n" +
                    ") S_ LIMIT " + offset + "," + limit + ") R_";
    }

    @Override
    public Class<?> getJavaType(String columnName, String dataType, int scale) {
        String var4 = dataType.toLowerCase();
        byte var5 = -1;
        switch(var4.hashCode()) {
            case -2073995239:
                if (var4.equals("longblob")) {
                    var5 = 5;
                }
                break;
            case -2073465431:
                if (var4.equals("longtext")) {
                    var5 = 3;
                }
                break;
            case -1769598430:
                if (var4.equals("mediumtext")) {
                    var5 = 2;
                }
                break;
            case -1389167889:
                if (var4.equals("bigint")) {
                    var5 = 10;
                }
                break;
            case -1325958191:
                if (var4.equals("double")) {
                    var5 = 13;
                }
                break;
            case -1312398097:
                if (var4.equals("tinyint")) {
                    var5 = 8;
                }
                break;
            case -606531192:
                if (var4.equals("smallint")) {
                    var5 = 9;
                }
                break;
            case 104431:
                if (var4.equals("int")) {
                    var5 = 7;
                }
                break;
            case 3026845:
                if (var4.equals("blob")) {
                    var5 = 4;
                }
                break;
            case 3052374:
                if (var4.equals("char")) {
                    var5 = 6;
                }
                break;
            case 3076014:
                if (var4.equals("date")) {
                    var5 = 15;
                }
                break;
            case 3556653:
                if (var4.equals("text")) {
                    var5 = 1;
                }
                break;
            case 55126294:
                if (var4.equals("timestamp")) {
                    var5 = 17;
                }
                break;
            case 97526364:
                if (var4.equals("float")) {
                    var5 = 12;
                }
                break;
            case 236613373:
                if (var4.equals("varchar")) {
                    var5 = 0;
                }
                break;
            case 1538337030:
                if (var4.equals("bigint unsigned")) {
                    var5 = 11;
                }
                break;
            case 1542263633:
                if (var4.equals("decimal")) {
                    var5 = 14;
                }
                break;
            case 1793702779:
                if (var4.equals("datetime")) {
                    var5 = 16;
                }
        }

        switch(var5) {
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
                return String.class;
            case 7:
            case 8:
            case 9:
            case 10:
            case 11:
                return Long.class;
            case 12:
            case 13:
                return Double.class;
            case 14:
                if (scale > 0) {
                    return Double.class;
                }

                return Long.class;
            case 15:
                return LocalDate.class;
            case 16:
            case 17:
                return LocalDateTime.class;
            default:
                throw new UnsupportedDataTypeJdbcException(columnName + "@" + dataType + "@" + scale);
        }
    }

    @Override
    public boolean isClob(ColumnContext columnContext) {
        String var2 = columnContext.getDataType().toLowerCase();
        byte var3 = -1;
        switch(var2.hashCode()) {
            case -2073465431:
                if (var2.equals("longtext")) {
                    var3 = 2;
                }
                break;
            case -1769598430:
                if (var2.equals("mediumtext")) {
                    var3 = 1;
                }
                break;
            case 3556653:
                if (var2.equals("text")) {
                    var3 = 0;
                }
        }

        switch(var3) {
            case 0:
            case 1:
            case 2:
                return true;
            default:
                return false;
        }
    }

    @Override
    public boolean isBlob(ColumnContext columnContext) {
        String var2 = columnContext.getDataType().toLowerCase();
        byte var3 = -1;
        switch(var2.hashCode()) {
            case -2073995239:
                if (var2.equals("longblob")) {
                    var3 = 1;
                }
                break;
            case 3026845:
                if (var2.equals("blob")) {
                    var3 = 0;
                }
        }

        switch(var3) {
            case 0:
            case 1:
                return true;
            default:
                return false;
        }
    }

    @Override
    public String getNullReplacementClause(String column, String valueOrColumn) {
        return "IFNULL( " + column + ", " + valueOrColumn + ")";
    }

    @Override
    public String getConcatClause(String... columnOrValues) {
        return null;
    }

//    public String getConcatClause(String... columnOrValues) {
//        StringBuilder sb = new StringBuilder("CONCAT(");
//        Arrays.stream(columnOrValues).forEach((v) -> {
//            sb.append("IFNULL(").append((String) ConvertUtils.convert(v, String.class, "")).append(",''),");
//        });
//        return sb.deleteCharAt(sb.length() - 1).append(")").toString();
//    }

    @Override
    public String getSelectFirstSql(String sql) {
        return "SELECT * FROM (\n" + sql + ") R_ LIMIT 1";
    }

    @Override
    public String getSelectTodoSql(String todoSql) {
        return "SELECT T.MENUID, T.MODELNAME, T.HREF, COUNT(1) QTY\n" + "  FROM (" + todoSql + ") T\n" + " GROUP BY T.MENUID, T.MODELNAME, T.HREF";
    }

    @Override
    public int getInClauseIdMaxQty() {
        return 10000;
    }

    @Override
    public int getMaxParamQty() {
        return 1000000;
    }

    @Override
    public List<String> getAddColumnSqlList(String tableName, ColumnMetadata columnMetadata) {
        return null;
    }

    @Override
    public String getDropColumnSql(String tableName, String columnName) {
        return null;
    }

//    public List<String> getAddColumnSqlList(String tableName, ColumnMetadata columnMetadata) {
//        if (!StringUtils.startsWithIgnoreCase(columnMetadata.getColumnName(), "EXT_")) {
//            throw new JdbcException("SINO.DATABASE.ALTER_TABLE.INVALID_PREFIX");
//        } else if (SqlHelper.isRiskySqlSegment(columnMetadata.getColumnName())) {
//            throw new HackingDataException(columnMetadata.getColumnName());
//        } else {
//            StringBuilder sql = (new StringBuilder("ALTER TABLE ")).append(tableName).append(" ADD COLUMN ").append(columnMetadata.getColumnName()).append(" ");
//            switch(columnMetadata.getDataType()) {
//                case STRING:
//                    sql.append("VARCHAR(").append(Optional.ofNullable(columnMetadata.getDataLength()).orElse(96)).append(") ");
//                    break;
//                case INTEGER:
//                    sql.append("INT ");
//                    break;
//                case DOUBLE:
//                    sql.append("DECIMAL(").append(Optional.ofNullable(columnMetadata.getDataLength()).orElse(16)).append(", ").append(Optional.ofNullable(columnMetadata.getDataScale()).orElse(6)).append(") ");
//                    break;
//                case CLOB:
//                    sql.append("TEXT ");
//                    break;
//                case DATE:
//                    sql.append("DATE ");
//                    break;
//                case DATETIME:
//                    sql.append("DATETIME ");
//            }
//
//            if (columnMetadata.isNullable()) {
//                sql.append(" NULL ");
//            } else {
//                sql.append(" NOT NULL ");
//            }
//
//            return Arrays.asList(sql.append(" COMMENT '").append((String)Optional.ofNullable(columnMetadata.getComments()).orElse("")).append("'").toString());
//        }
//    }

//    public String getDropColumnSql(String tableName, String columnName) {
//        if (!StringUtils.startsWithIgnoreCase(columnName, "EXT_")) {
//            throw new JdbcException("SINO.DATABASE.ALTER_TABLE.INVALID_PREFIX");
//        } else if (SqlHelper.isRiskySqlSegment(columnName)) {
//            throw new HackingDataException(columnName);
//        } else {
//            return "ALTER TABLE " + tableName + " DROP COLUMN " + columnName;
//        }
//    }
}
