/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.database.dialect;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.utils.ClassUtils;

import java.util.List;

public class DialectRepository {
    private static Dialect dialect;

    public DialectRepository() {
    }

    public static Dialect getDialect() {
        if (DialectRepository.dialect == null) {
            synchronized(DialectRepository.class) {
                if (DialectRepository.dialect == null) {
                    List<Class<?>> dialectClassList = ClassUtils.getPredicatedClasses("net.sinodawn", (c) -> !c.isInterface() && Dialect.class.isAssignableFrom(c));

                    for (Class<?> aClass : dialectClassList) {
                        Class<?> dialectClass = aClass;
                        Dialect dialect = (Dialect) ClassUtils.newInstance(dialectClass);
                        if (ApplicationContextHelper.isProfileActivated(dialect.getDatabase())) {
                            DialectRepository.dialect = dialect;
                            break;
                        }
                    }

                    if (DialectRepository.dialect == null) {
                        DialectRepository.dialect = new MysqlDialect();
                    }
                }
            }
        }

        return DialectRepository.dialect;
    }
}
