/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.database.dialect;

import net.sinodawn.framework.database.context.ColumnContext;

import java.util.List;

@SuppressWarnings("unused")
public interface Dialect {
    String EXTRA_COLUMN_PREFIX = "EXT_";

    /**
     * 获取数据库类型
     * @return 数据库类型
     */
    String getDatabase();

    /**
     * 根据表名拼接select语句
     * @param table 表名
     * @return SQL
     */
    String getSelectFromTableSql(String table);

    /**
     * limit语句
     * @param sql 拼接前SQL
     * @param offset 起始条数
     * @param limit 限定条数
     * @return 拼接后SQL
     */
    String getLimitSql(String sql, int offset, int limit);

    Class<?> getJavaType(String columnName, String dataType, int scale);

    boolean isClob(ColumnContext columnContext);

    boolean isBlob(ColumnContext columnContext);

    String getNullReplacementClause(String column, String valueOrColumn);

    String getConcatClause(String... columnOrValues);

    String getSelectFirstSql(String sql);

    String getSelectTodoSql(String todoSql);

    default String getSelectNoResultSql(String sql) {
        return "SELECT S.* FROM (" + sql + ") S WHERE 1 = 2";
    }

    int getInClauseIdMaxQty();

    int getMaxParamQty();

    default int getMaxBatchInsertQty() {
        return 2000;
    }

    List<String> getAddColumnSqlList(String tableName, ColumnMetadata columnMetadata);

    String getDropColumnSql(String tableName, String columnName);
}
