/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.database.dialect;

/**
 * 字段元数据类
 */
@SuppressWarnings("unused")
public class ColumnMetadata {
    private String columnName;
    private ColumnMetadata.DataType dataType;
    private Integer dataLength;
    private Integer dataScale;
    private boolean nullable = true;
    private String comments;

    public ColumnMetadata() {
    }

    /**
     * 返回实例
     * @param columnName 字段名
     * @param dataType 字段类型
     * @return ColumnMetadata实例
     */
    public static ColumnMetadata of(String columnName, ColumnMetadata.DataType dataType) {
        ColumnMetadata instance = new ColumnMetadata();
        instance.setColumnName(columnName);
        instance.setDataType(dataType);
        return instance;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public ColumnMetadata.DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(ColumnMetadata.DataType dataType) {
        this.dataType = dataType;
    }

    public Integer getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(Integer dataLength) {
        this.dataLength = dataLength;
    }

    public Integer getDataScale() {
        return this.dataScale;
    }

    public void setDataScale(Integer dataScale) {
        this.dataScale = dataScale;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public enum DataType {
        STRING,
        INTEGER,
        DOUBLE,
        CLOB,
        DATE,
        DATETIME;

        DataType() {
        }

        public static ColumnMetadata.DataType getByName(String name) {
            ColumnMetadata.DataType[] var1 = values();
            int var2 = var1.length;

            for (DataType dataType : var1) {
                if (dataType.name().equalsIgnoreCase(name)) {
                    return dataType;
                }
            }

            return null;
        }
    }
}
