/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.database.context.instance;

import net.sinodawn.framework.beans.BeanPropertyDescriptor;
import net.sinodawn.framework.database.context.EntityColumnContext;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ReflectionUtils;

import java.io.Serializable;

/**
 * 实体字段上下文实例
 */
@SuppressWarnings("unused")
public class EntityColumnContextInstance implements Serializable {
    private static final long serialVersionUID = -4726202530127803220L;
    private EntityColumnContext columnContext;
    private boolean active = false;
    /**
     * 字段值
     */
    private Object value;
    private boolean valueAssigned = true;

    private EntityColumnContextInstance() {
    }

    /**
     * 根据实体解析指定字段值
     * @param columnContext 实体字段上下文
     * @param entityValue 实体上下文
     * @return 实体字段上下文实例
     */
    public static EntityColumnContextInstance of(EntityColumnContext columnContext, Persistable<?> entityValue) {
        EntityColumnContextInstance instance = new EntityColumnContextInstance();
        instance.columnContext = columnContext;
        BeanPropertyDescriptor propertyDescriptor = columnContext.getPropertyDescriptor();
        if (propertyDescriptor.isExt$BeanProperty()) {
            if (!entityValue.getExt$().containsKey(columnContext.getColumnName())) {
                instance.valueAssigned = false;
            }

            instance.value = ConvertUtils.convert(entityValue.getExt$().get(columnContext.getColumnName()), columnContext.getType());
        } else {
            instance.value = ReflectionUtils.invokeMethod(propertyDescriptor.getReadMethod(), entityValue);
        }

        return instance;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public EntityColumnContext getColumnContext() {
        return this.columnContext;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isValueAssigned() {
        return this.valueAssigned;
    }
}
