/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.data.page;


import org.springframework.data.domain.Sort;

public interface Pageable extends org.springframework.data.domain.Pageable {
    int DEFAULT_FIRST_PAGE_NUMBER = 1;
    int DEFAULT_PAGE_SIZE = 50;

    void setPageNumber(int pageNumber);

    void setPageSize(int pageSize);

    void setSort(Sort sort);

    void setSumProperties(String... sumProperties);

    String[] getSumProperties();

    void setCountProperties(String... sumProperties);

    String[] getCountProperties();

    void setFilterJson(String filterJson);

    String getFilterJson();

    <T> T map(Class<T> searchTermsClazz);
}
