/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.data.page;


import com.alibaba.fastjson.JSONObject;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.data.domain.Sort;

import java.util.Optional;

public class PageRequest implements Pageable {
    private int pageNumber = 1;
    private int pageSize = 50;
    private String filterJson;
    private String[] sumProperties;
    private String[] countProperties;
    private Sort sort;

    public static PageRequest of(RestJsonWrapperBean wrapper) {
        PageRequest pageRequest = new PageRequest();
        pageRequest.setPageNumber(NumberUtils.parseInt(wrapper.getParamValue("n")));
        pageRequest.setPageSize(NumberUtils.parseInt(wrapper.getParamValue("s")));
        pageRequest.setFilterJson(wrapper.getParamValue("f"));
        pageRequest.setSumProperties(wrapper.getSumProperties());
        pageRequest.setCountProperties(wrapper.getCountProperties());
        return pageRequest;
    }

    public PageRequest() {
    }

    public int getPageNumber() {
        if (this.pageNumber == 0) {
            this.pageNumber = 1;
        }

        return this.pageNumber;
    }

    public int getPageSize() {
        if (this.pageSize == 0) {
            this.pageSize = 50;
        }

        return this.pageSize;
    }

    public long getOffset() {
        return this.getPageNumber() >= 0 && this.getPageSize() >= 0 ? (long)((this.getPageNumber() - 1) * this.getPageSize()) : 0L;
    }

    public Pageable next() {
        return this.getPageable(this.getPageNumber() + 1);
    }

    public Pageable previousOrFirst() {
        return this.getPageable(this.getPageNumber() > 1 ? this.getPageNumber() - 1 : 1);
    }

    public Pageable first() {
        return this.getPageable(1);
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public boolean hasPrevious() {
        return this.getPageNumber() > 1;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setFilterJson(String filterJson) {
        this.filterJson = filterJson;
    }

    public String getFilterJson() {
        return this.filterJson;
    }

    public <T> T map(Class<T> searchTermsClazz) {
        return StringUtils.isEmpty(this.filterJson) ? ClassUtils.newInstance(searchTermsClazz) : JSONObject.parseObject(this.filterJson, searchTermsClazz);
    }

    public void setSumProperties(String... sumProperties) {
        this.sumProperties = sumProperties;
    }

    public String[] getSumProperties() {
        return (String[]) Optional.ofNullable(this.sumProperties).orElse(new String[0]);
    }

    public String[] getCountProperties() {
        return (String[])Optional.ofNullable(this.countProperties).orElse(new String[0]);
    }

    public void setCountProperties(String... countProperties) {
        this.countProperties = countProperties;
    }

    private Pageable getPageable(int pageNumber) {
        Pageable pageable = new PageRequest();
        pageable.setPageNumber(pageNumber);
        pageable.setPageSize(this.pageSize);
        pageable.setFilterJson(this.filterJson);
        return pageable;
    }
}
