/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.data.page;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@SuppressWarnings("unused")
public interface Page<T> extends Serializable {
    int getTotalPages();

    int getNumberOfElements();

    boolean isFirst();

    boolean isLast();

    boolean hasNext();

    boolean hasPrevious();

    void setTotal(int total);

    int getTotal();

    void setPageSize(int pageSize);

    int getPageSize();

    void setPageNumber(int pageNumber);

    int getPageNumber();

    void setRows(List<T> rows);

    List<T> getRows();

    void setColumnTypeMap(Map<String, String> columnTypeMap);

    Map<String, String> getColumnTypeMap();

    void setTotalMap(Map<String, Number> totalMap);

    Map<String, Number> getTotalMap();
}
