/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.data;

import net.sinodawn.framework.exception.InvalidDataException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ListChunkIterator<I> implements ChunkIterator<I> {
   private final List<I> list;
   private final int chunkSize;
   private final int size;
   private int pos;

   private ListChunkIterator(List<I> list, int chunkSize) {
      this.list = (List)Objects.requireNonNull(list);
      this.chunkSize = (Integer)Objects.requireNonNull(chunkSize);
      this.size = list.size();
      this.pos = 0;
   }

   public boolean hasNext() {
      return this.pos < this.size;
   }

   public List<I> nextChunk() {
      if (!this.hasNext()) {
         throw new InvalidDataException("No more element.");
      } else {
         List<I> result = new ArrayList();
         int i;
         if (this.pos + this.chunkSize > this.size) {
            for(i = this.pos; i < this.size; ++i) {
               result.add(this.list.get(i));
            }

            this.pos = this.size;
         } else {
            for(i = this.pos; i < this.pos + this.chunkSize; ++i) {
               result.add(this.list.get(i));
            }

            this.pos += this.chunkSize;
         }

         return result;
      }
   }

   public int getChunkSize() {
      return this.chunkSize;
   }

   public static <I> ListChunkIterator<I> of(List<I> list, int chunkSize) {
      return new ListChunkIterator(list, chunkSize);
   }
}
