/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.string;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public enum StringToPropertiesConverter implements Converter<String, Properties> {
   INSTANCE;

   public Properties convert(String source) {
      try {
         Properties props = new Properties();
         props.load(new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8)));
         return props;
      } catch (IOException var3) {
         throw new ConvertFailedException(this.getSourceType(), this.getTargetType(), var3);
      }
   }
}
