/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.string;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.ConverterFactory;
import net.sinodawn.framework.utils.NumberUtils;

public enum StringToNumberConverterFactory implements ConverterFactory<String, Number> {
   INSTANCE;

   public <T extends Number> Converter<String, T> getConverter(Class<T> targetType) {
      return new StringToNumberConverter(targetType);
   }

   private class StringToNumberConverter<T extends Number> implements Converter<String, T> {
      private final Class<T> numberType;

      public StringToNumberConverter(Class<T> numberType) {
         this.numberType = numberType;
      }

      public Class<String> getSourceType() {
         return String.class;
      }

      public Class<T> getTargetType() {
         return this.numberType;
      }

      public T convert(String source) {
         return NumberUtils.parseNumber(source, this.getTargetType());
      }
   }
}
