/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.string;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.ConverterFactory;
import net.sinodawn.framework.utils.StringUtils;

public enum StringToEnumConverterFactory implements ConverterFactory<String, Enum> {
   INSTANCE;

   public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
      return new StringToEnumConverter(targetType);
   }

   private class StringToEnumConverter<T extends Enum> implements Converter<String, T> {
      private final Class<T> enumType;

      public StringToEnumConverter(Class<T> enumType) {
         this.enumType = enumType;
      }

      public Class<String> getSourceType() {
         return String.class;
      }

      public Class<T> getTargetType() {
         return this.enumType;
      }

      public T convert(String source) {
         return StringUtils.isEmpty(source) ? null : (T)Enum.valueOf(this.enumType, source.trim());
      }
   }
}
