/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.string;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.ConverterFactory;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import net.sinodawn.framework.converter.exception.ConverterNotFoundException;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.DateTimeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;

/** @deprecated */
@Deprecated
public enum StringToDateConverterFactory implements ConverterFactory<String, Date> {
   INSTANCE;

   public <T extends Date> Converter<String, T> getConverter(Class<T> targetType) {
      return new StringToDateConverter(targetType);
   }

   private class StringToDateConverter<T extends Date> implements Converter<String, T> {
      private final Class<T> dateType;

      public StringToDateConverter(Class<T> dateType) {
         this.dateType = dateType;
      }

      public Class<String> getSourceType() {
         return String.class;
      }

      public Class<T> getTargetType() {
         return this.dateType;
      }

      public T convert(String source) {
         Date date = DateTimeUtils.parseDate(source);
         if (date == null) {
            return null;
         } else {
            Constructor<T> constructor = ClassUtils.getConstructorIfAvailable(this.dateType, Long.class);
            if (constructor != null) {
               try {
                  return constructor.newInstance(date.getTime());
               } catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | InstantiationException var5) {
                  throw new ConvertFailedException(this.getSourceType(), this.getTargetType(), var5);
               }
            } else {
               throw new ConverterNotFoundException(this.getSourceType(), this.getTargetType());
            }
         }
      }
   }
}
