/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.string;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialClob;

public enum StringToClobConverter implements Converter<String, Clob> {
   INSTANCE;

   public Clob convert(String source) {
      if (source == null) {
         return null;
      } else {
         try {
            return new SerialClob(source.toCharArray());
         } catch (SQLException var3) {
            throw new ConvertFailedException(this.getSourceType(), this.getTargetType(), var3);
         }
      }
   }
}
