/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.string;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConvertFailedException;

public enum StringToBooleanConverter implements Converter<String, Boolean> {
   INSTANCE;

   public Boolean convert(String source) {
      if (source == null) {
         return null;
      } else if (!"true".equalsIgnoreCase(source) && !"yes".equalsIgnoreCase(source) && !"on".equalsIgnoreCase(source) && !"1".equalsIgnoreCase(source)) {
         if (!"false".equalsIgnoreCase(source) && !"no".equalsIgnoreCase(source) && !"off".equalsIgnoreCase(source) && !"0".equalsIgnoreCase(source)) {
            throw new ConvertFailedException(this.getSourceType(), this.getTargetType(), source);
         } else {
            return Boolean.FALSE;
         }
      } else {
         return Boolean.TRUE;
      }
   }
}
