/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.string;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;

public enum StringToBlobConverter implements Converter<String, Blob> {
   INSTANCE;

   public Blob convert(String source) {
      if (source == null) {
         return null;
      } else {
         try {
            return new SerialBlob(source.getBytes(StandardCharsets.UTF_8));
         } catch (SQLException var3) {
            throw new ConvertFailedException(this.getSourceType(), this.getTargetType(), var3);
         }
      }
   }
}
