/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.sql;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;

public enum ClobToStringConverter implements Converter<Clob, String> {
   INSTANCE;

   public String convert(Clob source) {
      if (source == null) {
         return null;
      } else {
         Clob clob = source;
         Reader reader = null;

         String var5;
         try {
            reader = clob.getCharacterStream();
            char[] chars = new char[(int)clob.length()];
            reader.read(chars);
            var5 = String.valueOf(chars);
         } catch (IOException | SQLException var14) {
            throw new ConvertFailedException(this.getSourceType(), this.getTargetType(), var14);
         } finally {
            if (reader != null) {
               try {
                  reader.close();
               } catch (IOException var13) {
               }
            }

         }

         return var5;
      }
   }
}
