/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.sql;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import java.io.IOException;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

public enum ClobToPrimitiveCharacterArrayConverter implements Converter<Clob, char[]> {
   INSTANCE;

   public char[] convert(Clob source) {
      if (source == null) {
         return null;
      } else {
         Reader reader = null;

         char[] chars;
         try {
            if (source.length() != 0L) {
               reader = source.getCharacterStream();
               chars = new char[(int)source.length()];
               reader.read(chars);
               char[] var4 = chars;
               return var4;
            }

            chars = new char[0];
         } catch (IOException | SQLException var14) {
            throw new ConvertFailedException(Blob.class, byte[].class, var14);
         } finally {
            if (reader != null) {
               try {
                  reader.close();
               } catch (IOException var13) {
               }
            }

         }

         return chars;
      }
   }
}
