/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.sql;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;

public enum BlobToStringConverter implements Converter<Blob, String> {
   INSTANCE;

   public String convert(Blob source) {
      if (source == null) {
         return null;
      } else {
         try {
            return new String(source.getBytes(1L, (int)source.length()), StandardCharsets.UTF_8);
         } catch (SQLException var3) {
            throw new ConvertFailedException(this.getSourceType(), this.getTargetType(), var3);
         }
      }
   }
}
