/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.sql;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public enum BlobToPrimitiveByteArrayConverter implements Converter<Blob, byte[]> {
   INSTANCE;

   public byte[] convert(Blob source) {
      if (source == null) {
         return null;
      } else {
         InputStream is = null;

         byte[] bytes;
         try {
            if (source.length() != 0L) {
               is = source.getBinaryStream();
               bytes = new byte[(int)source.length()];
               is.read(bytes, 0, (int)source.length());
               byte[] var4 = bytes;
               return var4;
            }

            bytes = new byte[0];
         } catch (IOException | SQLException var14) {
            throw new ConvertFailedException(Blob.class, byte[].class, var14);
         } finally {
            if (is != null) {
               try {
                  is.close();
               } catch (IOException var13) {
               }
            }

         }

         return bytes;
      }
   }
}
