/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.number;


import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.ConverterFactory;
import net.sinodawn.framework.converter.exception.ConverterNotFoundException;

import java.math.BigDecimal;
import java.math.BigInteger;

@SuppressWarnings({"unchecked", "rawtypes", "unused"})
public enum NumberToNumberConverterFactory implements ConverterFactory<Number, Number> {
    INSTANCE;

    NumberToNumberConverterFactory() {
    }

    public <T extends Number> Converter<Number, T> getConverter(Class<T> targetType) {
        return new NumberToNumberConverter(targetType);
    }

    private static class NumberToNumberConverter<T extends Number> implements Converter<Number, T> {
        private final Class<T> numberType;

        public NumberToNumberConverter(Class<T> numberType) {
            this.numberType = numberType;
        }

        public Class<Number> getSourceType() {
            return Number.class;
        }

        public Class<T> getTargetType() {
            return this.numberType;
        }

        public T convert(Number source) {
            if (source == null) {
                return null;
            } else {
                Class<T> targetType = this.getTargetType();
                if (Byte.class != targetType && Byte.TYPE != targetType) {
                    if (Short.class != targetType && Short.TYPE != targetType) {
                        if (Integer.class != targetType && Integer.TYPE != targetType) {
                            if (Long.class != targetType && Long.TYPE != targetType) {
                                if (Float.class != targetType && Float.TYPE != targetType) {
                                    if (Double.class != targetType && Double.TYPE != targetType) {
                                        if (BigInteger.class == targetType) {
                                            return (T) BigInteger.valueOf(source.longValue());
                                        } else if (BigDecimal.class == targetType) {
                                            return (T) BigDecimal.valueOf(source.doubleValue());
                                        } else {
                                            throw new ConverterNotFoundException(this.getSourceType(), targetType);
                                        }
                                    } else {
                                        return (T) Double.valueOf(source.doubleValue());
                                    }
                                } else {
                                    return (T) Float.valueOf(source.floatValue());
                                }
                            } else {
                                return (T) Long.valueOf(source.longValue());
                            }
                        } else {
                            return (T) Integer.valueOf(source.intValue());
                        }
                    } else {
                        return (T) Short.valueOf(source.shortValue());
                    }
                } else {
                    return (T) Byte.valueOf(source.byteValue());
                }
            }
        }
    }
}
