/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.number;

import net.sinodawn.framework.converter.Converter;

public enum NumberToBooleanConverter implements Converter<Number, Boolean> {
   INSTANCE;

   public Class<Number> getSourceType() {
      return Number.class;
   }

   public Class<Boolean> getTargetType() {
      return Boolean.class;
   }

   public Boolean convert(Number source) {
      return source == null ? null : source.doubleValue() > 0.0D;
   }
}
